#include <windows>
#include <setupapi>
#include <iostream>
#include <assert>
#include <sysutils.hpp>


using namespace std;

void displayError(const char* msg){
  cout << msg << endl;
  system("PAUSE");
  exit(0);
};
//---------------------------------------------------------
template <class T>
inline void releaseMemory(T &x)
{
  assert(x != NULL);
  delete x;
  x = NULL;
}
//---------------------------------------------------------
typedef USHORT USAGE, *PUSAGE;
typedef struct _HIDP_PREPARSED_DATA *PHIDP_PREPARSED_DATA;
PHIDP_PREPARSED_DATA preparsedData;

typedef struct _HIDP_CAPS {
   USAGE Usage;
   USAGE UsagePage;
   USHORT InputReportByteLength;
   USHORT OutputReportByteLength;
   USHORT FeatureReportByteLength;
   USHORT Reserved[17];
   USHORT NumberLinkCollectionNodes;
   USHORT NumberInputButtonCaps;
   USHORT NumberInputValueCaps;
   USHORT NumberInputDataIndices;
   USHORT NumberOutputButtonCaps;
   USHORT NumberOutputValueCaps;
   USHORT NumberOutputDataIndices;
   USHORT NumberFeatureButtonCaps;
   USHORT NumberFeatureValueCaps;
   USHORT NumberFeatureDataIndices;
} HIDP_CAPS, *PHIDP_CAPS;
//---------------------------------------------------------
typedef enum _HIDP_REPORT_TYPE {
  HidP_Input,
  HidP_Output,
  HidP_Feature
} HIDP_REPORT_TYPE;
//----------------------------------------------------------
typedef struct _USAGE_AND_PAGE {
  USAGE Usage;
  USAGE UsagePage;
} USAGE_AND_PAGE, * PUSAGE_AND_PAGE;
//----------------------------------------------------------
HIDP_CAPS capabilities;

GUID classGuid;
HMODULE hHidLib;
DWORD memberIndex = 0;
DWORD deviceInterfaceDetailDataSize;

HDEVINFO deviceInfoSet;
SP_DEVICE_INTERFACE_DATA deviceInterfaceData;
PSP_DEVICE_INTERFACE_DETAIL_DATA deviceInterfaceDetailData = NULL;

HANDLE  hidDeviceObject;

BYTE *inputReportBuffer; //bufor danych wejsciowych
DWORD numberOfBytesRead = 0;

int main()
{

  void (__stdcall *HidD_GetHidGuid)(OUT LPGUID HidGuid);

  long (__stdcall* HidP_GetCaps)(IN PHIDP_PREPARSED_DATA PreparsedData,
                                    OUT PHIDP_CAPS Capabilities);
  bool (__stdcall* HidD_GetPreparsedData)(IN HANDLE  HidDeviceObject,
                                    OUT PHIDP_PREPARSED_DATA *PreparsedData);

  bool (__stdcall* HidD_FreePreparsedData)(IN PHIDP_PREPARSED_DATA PreparsedData);

  unsigned long (*HidP_MaxUsageListLength)(HIDP_REPORT_TYPE ReportType,
                                    IN USAGE UsagePage  OPTIONAL,
                                    PHIDP_PREPARSED_DATA PreparsedData);

  unsigned int (__stdcall *HidP_GetUsagesEx)(IN HIDP_REPORT_TYPE  ReportType,
                                    IN USHORT  LinkCollection  OPTIONAL,
                                    IN OUT PUSAGE_AND_PAGE  ButtonList,
                                    IN OUT ULONG *  UsageLength,
                                    IN PHIDP_PREPARSED_DATA PreparsedData,
                                    IN PCHAR  Report,
                                    IN ULONG  ReportLength);

  unsigned int (__stdcall *HidP_UsageListDifference)(IN PUSAGE PreviousUsageList,
                                    IN PUSAGE  CurrentUsageList,
                                    OUT PUSAGE  BreakUsageList,
                                    OUT PUSAGE  MakeUsageList,
                                    IN ULONG  UsageListLength);


  hHidLib = LoadLibrary("HID.DLL");
  if (!hHidLib)
    displayError("Bad doaczenia biblioteki HID.DLL.");

  (FARPROC&) HidD_GetHidGuid=GetProcAddress(hHidLib, "HidD_GetHidGuid");
  (FARPROC&) HidP_GetCaps=GetProcAddress(hHidLib,
                                             "HidP_GetCaps");
  (FARPROC&) HidD_GetPreparsedData=GetProcAddress(hHidLib,
                                             "HidD_GetPreparsedData");
  (FARPROC&) HidD_FreePreparsedData=GetProcAddress(hHidLib,
                                             "HidD_FreePreparsedData");
  (FARPROC&) HidP_MaxUsageListLength=GetProcAddress(hHidLib,
                                    "HidP_MaxUsageListLength");
  (FARPROC&) HidP_GetUsagesEx=GetProcAddress(hHidLib,
                                    "HidP_GetUsagesEx");
  (FARPROC&) HidP_UsageListDifference=GetProcAddress(hHidLib,
                                    "HidP_UsageListDifference");

   if (!HidD_GetHidGuid || !HidD_GetPreparsedData
       || !HidD_FreePreparsedData || !HidP_GetUsagesEx ||
       !HidP_UsageListDifference || !HidP_MaxUsageListLength
       || !HidP_GetCaps){
      FreeLibrary(hHidLib);
      displayError("Nie znaleziono jednej lub wicej funkcji eksportowych.\n");
   }

   HidD_GetHidGuid(&classGuid);

   deviceInfoSet = SetupDiGetClassDevs(&classGuid, NULL, NULL,
                   DIGCF_PRESENT | DIGCF_INTERFACEDEVICE);
   if (deviceInfoSet == INVALID_HANDLE_VALUE){
      FreeLibrary(hHidLib);
      displayError("Nie zidentyfikowano podczonych urzdze.\n");
   }

   deviceInterfaceData.cbSize = sizeof(SP_DEVICE_INTERFACE_DATA);


   while(SetupDiEnumDeviceInterfaces(deviceInfoSet, NULL, &classGuid,
                                     memberIndex, &deviceInterfaceData)){
       memberIndex++; //inkrementacja numeru interfejsu
       SetupDiGetDeviceInterfaceDetail(deviceInfoSet, &deviceInterfaceData,
                             NULL, 0, &deviceInterfaceDetailDataSize, NULL);
       deviceInterfaceDetailData = (PSP_DEVICE_INTERFACE_DETAIL_DATA)
                              new DWORD[deviceInterfaceDetailDataSize];
       deviceInterfaceDetailData->cbSize=sizeof(SP_DEVICE_INTERFACE_DETAIL_DATA);
       if (!SetupDiGetDeviceInterfaceDetail(deviceInfoSet, &deviceInterfaceData,
            deviceInterfaceDetailData, deviceInterfaceDetailDataSize,
            NULL, NULL)){
          releaseMemory(deviceInterfaceDetailData);
          SetupDiDestroyDeviceInfoList(deviceInfoSet);
          displayError("Nie mona pobra informacji o interfejsie.\n");
       }

       if (NULL != strstr(deviceInterfaceDetailData->DevicePath, "vid_22ba")){
          cout << "\n"<< deviceInterfaceDetailData->DevicePath << "\n";
          hidDeviceObject=CreateFile(deviceInterfaceDetailData->DevicePath,
                                     GENERIC_READ, FILE_SHARE_READ,
                                     NULL,OPEN_EXISTING,0,NULL);
          break;
       }
       releaseMemory(deviceInterfaceDetailData);
   };//koniec while

   SetupDiDestroyDeviceInfoList(deviceInfoSet);

   HidD_GetPreparsedData(hidDeviceObject, &preparsedData);

   HidP_GetCaps(preparsedData, &capabilities);
   printf("Usage=%d\nUsagePage=%d\nInputReportByteLength=%d\n"
           "OutputReportByteLength=%d\nFeatureReportByteLength=%d\n"
           "NumberInputButtonCaps=%d\nNumberInputValueCaps=%d\n\n",
           capabilities.Usage,capabilities.UsagePage,
           capabilities.InputReportByteLength,
           capabilities.OutputReportByteLength,
           capabilities.FeatureReportByteLength,
           capabilities.NumberInputButtonCaps,
           capabilities.NumberInputValueCaps);
   //--------------------------------------------------
   ULONG usageListLength = HidP_MaxUsageListLength(HidP_Input, 0, preparsedData);
   printf("Max Usages (liczba przyciskw) = %d\n", usageListLength);
   //--------------------------------------------------
   inputReportBuffer = new BYTE[capabilities.InputReportByteLength];
  //---------------------------------------------------------
   USAGE_AND_PAGE *Usages = new USAGE_AND_PAGE[usageListLength];
   const ULONG maxPreviousUsages = 14;
   USAGE previousUsages[maxPreviousUsages];

   while(true) { //cykliczny odczyt danych z wybranego urzdzenia
       memset(inputReportBuffer, 0x00, capabilities.InputReportByteLength);
       ReadFile(hidDeviceObject, inputReportBuffer,
                capabilities.InputReportByteLength,
                &numberOfBytesRead, NULL);
       if(numberOfBytesRead==capabilities.InputReportByteLength){
           for(USHORT i=0; i<capabilities.InputReportByteLength; i++)
               printf("%d ", inputReportBuffer[i]);
               printf("\n");

           ULONG validUsages = usageListLength;
           HidP_GetUsagesEx(HidP_Input, 0, Usages, &validUsages,
                            preparsedData, inputReportBuffer,
                            capabilities.InputReportByteLength);

           USAGE *currentUsages = new USAGE[maxPreviousUsages];
           USAGE *breakUsages = new USAGE[maxPreviousUsages];
           USAGE *makeUsages = new USAGE[maxPreviousUsages];

           //stan aktualnie uywanych przyciskw
           memset(currentUsages, 0, sizeof(currentUsages));
           printf("Zbor przyciskow: ");
           for(ULONG i=0; i<validUsages; i++) {
               printf( "UsagePage=%d  Usage=%d\n ", Usages[i].UsagePage,
                      Usages[i].Usage);
               currentUsages[i] = Usages[i].Usage;
           }

           HidP_UsageListDifference(previousUsages, currentUsages,
                                    breakUsages, makeUsages, usageListLength);

           printf("BreakList: ");
           for(ULONG i=0; i<usageListLength; i++){
              if(breakUsages[i]==0) break;
                  printf("%d ", breakUsages[i]);
           }
           printf("MakeList: ");
           for(ULONG i=0; i<usageListLength; i++){
              if(makeUsages[i]==0) break;
                 printf("%d ", makeUsages[i]);
           }
           printf("\n\n");
           //zapis poprzednich ustawien
           memcpy(previousUsages, currentUsages, usageListLength*sizeof(USAGE));
           releaseMemory(currentUsages);
           releaseMemory(breakUsages);
           releaseMemory(makeUsages);
       }
       else {
            printf("Bdna liczba bajtow odebranych.\n",numberOfBytesRead);
            break;
       }
       if(inputReportBuffer[6]==64) {
           HidD_FreePreparsedData(preparsedData);
           Win32Check(CloseHandle(hidDeviceObject));
           break;
       }
   }

   //if(hidDeviceObject != INVALID_HANDLE_VALUE)
   //    Win32Check(CloseHandle(hidDeviceObject));
   releaseMemory(inputReportBuffer);
   FreeLibrary(hHidLib);
   cout << endl;
   system("PAUSE");
   return 0;
}
//---------------------------------------------------------

